extends StaticBody3D


enum kick_states {
	UNKICKED,
	KICKED_LEFT,
	KICKED_RIGHT
}
var kick_state: int = kick_states.UNKICKED

func kick(caller):
	# Check which area the caller is in.
	# If the caller is in the left area, kick the table over to the right.
	# If the caller is in the right area, kick the table over to the left.
	for side in [$kick_area_left, $kick_area_right]:
		$kick_area_left.get_overlapping_bodies()
		var bodies: Array = side.get_overlapping_bodies()
		if caller in bodies:
			print("Kicker side: "+ side.name)
			if side.name.contains("left"):
				$AnimationPlayer.play("kick_to_right")
			elif side.name.contains("right"):
				$AnimationPlayer.play("kick_to_left")
			remove_from_group("kickables")
			set_script("")
			break
	return
