extends World

var glass_cell_master: PackedScene = preload("res://Scenes/glass_cell.tscn")
var dynamic_glass_test: Node3D
var dynamic_glass_meshinst: MeshInstance3D
var stress_test_ticker: int = 0

func _ready():

	#for h_grunt in self.find_children("h_grunt_*", "CharacterBody3D"):
		#for gruntmesh in h_grunt.find_children("*", "MeshInstance3D"):
			#gruntmesh.transparency = .5
	
	#await get_tree().create_timer(2.0).timeout
	#prints(self.name, get_tree().get_first_node_in_group("wg_sc"))
	#var wg: Node3D = get_tree().get_first_node_in_group("wg_sc")
	#wg.get_node("AnimationPlayer").play("die_torso")
	#wg.get_node("AnimationPlayer").pause()
	#wg.get_node("AnimationPlayer").seek(.3)
	
	## I don't know if this'll ever be a thing. Don't think so.
	#dynamic_glass_test = $NavigationRegion3D/Map.find_child("dynamic_glass_test")
	#dynamic_glass_meshinst = dynamic_glass_test.find_children("*", "MeshInstance3D")[0]
	#var glass_endpoints: Array = U.get_aabb_global_endpoints(dynamic_glass_meshinst)
	#for glass_endpoint in glass_endpoints:
		#U.spawn_blue_marker(Blackboard.current_world, glass_endpoint, 999.0)
	
	#var glass_endpoints: Dictionary = U.get_aabb_global_endpoints_rich(dynamic_glass_meshinst)
	#var bottom_indices: Array = [0, 1, 4, 5]
	#for i in glass_endpoints:
		#if bottom_indices.has(i):
			#U.spawn_blue_marker(Blackboard.current_world, glass_endpoints[i], 999.0)
		#else:
			#U.spawn_green_marker(Blackboard.current_world, glass_endpoints[i], 999.0)
	
	
	return


func _on_stress_test_ticker_timeout() -> void:
	for i in range(100):
		var last_stressitem: PhysicsBody3D = get_tree().get_nodes_in_group("stress_test_duplication_client")[-1]
		var new_thing: PhysicsBody3D = last_stressitem.duplicate()
		Blackboard.current_world.add_child(new_thing)
		new_thing.global_position = last_stressitem.global_position
		new_thing.global_position.y += 10.0
		await get_tree().create_timer(.1).timeout
	return


func _on_debug_canvas_ticker_timeout() -> void:
	#update_debug_canvas()
	return

func update_debug_canvas() -> void:
	if $debug_canvas/label.visible:
		#$debug_canvas/label.text = get_node_tree_count_text($"NavigationRegion3D/Map/@Node3D@26651".get_node("anchor"))
		$debug_canvas/label.text = str(randi_range(0, 10))
		if U.coin_flip() and U.coin_flip():
			$Container_1/debug_canvas_ticker.process_mode = Node.PROCESS_MODE_DISABLED
		pass
	return

func get_node_tree_count_text(node: Node) -> String:
	var tree_text: String = node.name + " : " + node.get_class() + "[" + str(node.get_child_count()) + "]"
	var class_count: Dictionary = {}
	for c1 in node.get_children():
		if not class_count.has(c1.get_class()):
			class_count[c1.get_class()] = 0
		class_count[c1.get_class()] += 1
	
	for class_string in class_count.keys():
		tree_text += "\n|-- " + class_string + " ("+ str(class_count[class_string]) +")"
	return tree_text

func get_node_tree_text(node: Node) -> String:
	var tree_text: String = node.name + " : " + node.get_class() + "[" + str(node.get_child_count()) + "]"
	#for c1 in node.find_children("*", "", false):
		#tree_text += "\n - " + c1.get_class()
		#for c2 in c1.find_children("*", "", false):
			#tree_text += " > " + c2.get_class()
	for c1 in node.get_children():
		tree_text += "\n - " + c1.get_class()
		#if c1.get_child_count() > 0:
			#tree_text += "\n"
		#for c2 in c1.get_children():
			#tree_text += "\n|-- > " + c2.get_class()
	
	return tree_text
