extends World

@onready var map: TBLoader = $NavigationRegion3D/Map
var expected_enemy_groups: Array = [] # ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys"]
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_vela_office_triggered: bool = false
var is_exit_available: bool = false
var is_exit_triggered: bool = false
var is_scene_endable: bool = false

#var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false

@onready var exit_player_pos: Marker3D = null # $External/Exit/exit_player_pos
@onready var exit_light: Node3D = null # $External/Exit/exit_light
@onready var exit_music: AudioStreamPlayer3D = null # $External/Exit/exit_music
@onready var exit_screen: Control = null # $External/Exit/exit_screen
var keep_player_inventory: bool = true

@onready var vela: CharacterBody3D = $Actors/vela_cinem
@onready var closed_gate: Node3D = $"NavigationRegion3D/Map/closed_gate-nocol"
@onready var spawn_points: Array = $Externals/spawn_points.get_children()

var h_grunt_master: PackedScene = preload("res://Scenes/h_grunt.tscn")
var malemook_master: PackedScene = preload("res://Scenes/mook_biker.tscn")

var spawn_point_cycle_index: int = 0
@onready var spawn_point_indices: Array = range(spawn_points.size())

func _ready():
	spawn_point_indices.shuffle()
	closed_gate.visible = false
	toggle_exit_zone(true)
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	
	$Externals/Sounds.find_children("truck_door_*").pick_random().play()
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	return

func _physics_process(delta):
	if not full_init: return
	
	total_time += delta
	
	#if is_scene_endable and Input.is_anything_pressed():
		#scene_ended.emit()
	
	if is_exit_available:
		exit_area_control()
	# Goofing around \/
	# Goofing around /\
	return


func exit_level():
	if is_exit_triggered:
		return
	
	is_exit_triggered = true
	scene_ended.emit()
	return


func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return



func toggle_exit_zone(toggle: bool) -> void:
	# Walk into exit light, end level
	if toggle == true:
		$Externals/EXIT/exit_light_local.visible = true
		is_exit_available = true
		return
	elif toggle == false:
		$Externals/EXIT/exit_light_local.visible = false
		is_exit_available = false
		return
		
	return

func exit_area_control() -> void:
	if is_exit_triggered: return
	var bodies: Array = $Externals/EXIT/exit_area.get_overlapping_bodies()
	if not bodies:
		return
	for b in bodies:
		if b.is_in_group("players"):
			exit_level()
			return
	return

func spawn_grunt() -> void:
	spawn_point_cycle_index = U.cycled_array_index(spawn_point_indices, spawn_point_cycle_index)
	var spawn_point_index: int = spawn_point_indices[spawn_point_cycle_index]
	var spawn_point: Marker3D = spawn_points[spawn_point_index]
	var new_grunt: PhysicsBody3D = h_grunt_master.instantiate()
	Blackboard.current_world.add_child(new_grunt)
	new_grunt.global_position = spawn_point.global_position
	new_grunt.global_rotation.y = randf_range(-95.0, 95.0)
	new_grunt.active_target = $noko_actor
	return

func spawn_mook() -> void:
	spawn_point_cycle_index = U.cycled_array_index(spawn_point_indices, spawn_point_cycle_index)
	var spawn_point_index: int = spawn_point_indices[spawn_point_cycle_index]
	var spawn_point: Marker3D = spawn_points[spawn_point_index]
	var new_mook: PhysicsBody3D = malemook_master.instantiate()
	Blackboard.current_world.add_child(new_mook)
	new_mook.global_position = spawn_point.global_position
	new_mook.global_rotation.y = randf_range(-95.0, 95.0)
	new_mook.active_target = $noko_actor
	return

func _on_spawn_timer_timeout() -> void:
	var total_grunts_and_mooks: int = 0
	for enemy_group in ["h_grunts", "mooks"]:
		for enemy_node in get_tree().get_nodes_in_group(enemy_group):
			if not enemy_node or not is_instance_valid(enemy_node):
				continue
			if enemy_node.is_dead:
				continue
			total_grunts_and_mooks += 1
	#var total_grunts_and_mooks: int = get_tree().get_nodes_in_group("h_grunts").size() + get_tree().get_nodes_in_group("mooks").size()
	if total_grunts_and_mooks > spawn_points.size():
		return
	[spawn_grunt, spawn_grunt, spawn_grunt, spawn_mook].pick_random().call()
	return


func _on_getaway_timer_timeout() -> void:
	$spawn_timer.start()
	return


func _on_vela_office_area_body_entered(body: Node3D) -> void:
	if is_vela_office_triggered: return
	if not body.is_in_group("players"):
		return
	
	is_vela_office_triggered = true
	vela.activate_custom_audio()
	return
