extends Node3D

@export var die_on_finish: bool = true
@onready var standard_sprites: Array = $standard.get_children()
@onready var skinny_sprites: Array = $skinny.get_children()

func _ready():
	reset_sprites_alpha()
	return



func reset_sprites_alpha():
	for sprite in standard_sprites:
		sprite.modulate = Color(1.0, 1.0, 1.0, 0.0)
	for sprite in skinny_sprites:
		sprite.modulate = Color(1.0, 1.0, 1.0, 0.0)
	return

func puff(duration: float = 0.2):
	for sprite in standard_sprites:
		sprite.modulate = Color(1.0, 1.0, 1.0, 1.0)
		get_tree().create_tween().tween_property(sprite, "modulate", Color(1.0, 1.0, 1.0, 0.0), duration)
	if die_on_finish:
		await get_tree().create_timer(duration + 0.1).timeout
		self.queue_free()
	return

func skinny_puff(duration: float = 0.2):
	for sprite in skinny_sprites:
		sprite.modulate = Color(1.0, 1.0, 1.0, 1.0)
		get_tree().create_tween().tween_property(sprite, "modulate", Color(1.0, 1.0, 1.0, 0.0), duration)
	if die_on_finish:
		await get_tree().create_timer(duration + 0.1).timeout
		self.queue_free()
	return
