extends Control

# TODO
# - Use a syncer node to sync players (mouselook works but needs occasional adjustment)
# - Fix obvious issues (cameras, slots, crouching, etc.)
# - Make a net random proxy for random methods (rng table? :3)

const PORT: int = 7855
var server_address: String = ""
@onready var netstart_ui: VBoxContainer = $netstart_buttons
@onready var netmain_ui: Control = $netmain_controls
@onready var server_address_edit: TextEdit = $netstart_buttons/server_address_edit
@onready var player_list: VBoxContainer = $lobby_container/player_list
@onready var player_list_item_template: TextEdit = $lobby_container/player_list/player_list_item_template
@onready var lobby_container: Control = $lobby_container
@onready var player_name_edit: TextEdit = $netstart_buttons/player_name_edit
@onready var net_input_proxy: Node = $net_input_proxy
@onready var player_synchronizer: MultiplayerSynchronizer = $player_synchronizer

var net_dark_room_fpath: String = "res://Scenes/net_test_core_rnd.tscn"

#var players: Array = [
	#{
		#"peer_id": -1,
		#"name": "example_player"
	#}
#]
var player_peers: Dictionary = {}
var is_host_waiting: bool = false

@export var net_player_index: int = 0 # DEBUG```

func _ready():
	seed(1)
	
	get_tree().get_multiplayer().connect("peer_connected", _peer_connected)
	get_tree().get_multiplayer().connect("peer_disconnected", _peer_disconnected)
	server_address_edit.connect("text_changed", _server_address_edit_text_changed)
	
	$peer_id.text = str(multiplayer.get_unique_id())
	#for i in range(len(players)):
		#var player_index: int = i - 1
		#if players[player_index]["name"] == "example_player":
			#players.remove_at(player_index)
			#break
	return

func _process(delta):
	#update_player_list() # Lazy
	return

func _peer_connected(id: int):
	$peer_id.text = str(multiplayer.get_unique_id())
	prints(self.name, str(multiplayer.get_unique_id()), "Peer connected:", str(id))
	send_player_data()
	return

func _peer_disconnected(id: int):
	$peer_id.text = str(multiplayer.get_unique_id())
	prints(self.name, "Peer disconnected:", str(id))
	player_peers.erase(id)
	update_player_list()
	return

func _server_address_edit_text_changed():
	server_address = server_address_edit.text
	return

func _on_host_pressed():
	if not player_name_edit.text:
		player_name_edit.text = "sprayer"
	
	var peer = ENetMultiplayerPeer.new()
	peer.create_server(PORT, 4)
	get_tree().get_multiplayer().multiplayer_peer = peer
	prints(self.name, get_tree().get_multiplayer().get_unique_id(), "Server created.")
	
	### Getting mid-game sync will take some thought
	### Commented out to make way for queue-and-go (QAG)
	#load_map.call_deferred(net_dark_room_fpath)
	#ui_start_to_main()
	
	is_host_waiting = true
	netstart_ui.hide()
	lobby_container.show()
	$lobby_container/Launch.show()
	
	player_peers[get_tree().get_multiplayer().get_unique_id()] = {"name": player_name_edit.text}
	update_player_list()
	return

@rpc("any_peer", "call_local")
func update_player_list():
	for player_item in player_list.get_children():
		if player_item.name.contains("template"):
			continue
		player_item.free()
	for peer in player_peers.keys():
		add_listed_player(player_peers[peer]["name"])
	return

func _on_join_pressed():
	prints(self.name, get_tree().get_multiplayer().get_unique_id(), "Client attempting to join server", "'"+server_address+"'")
	if not player_name_edit.text:
		player_name_edit.text = "sprayer"
	
	if not server_address:
		server_address = "127.0.0.1"
	
	
	var peer = ENetMultiplayerPeer.new()
	peer.create_client(server_address, PORT)
	get_tree().get_multiplayer().multiplayer_peer = peer
	prints(self.name, get_tree().get_multiplayer().get_unique_id(), "Client successfully joined server.")
	
	netstart_ui.hide()
	lobby_container.show()
	
	player_peers[get_tree().get_multiplayer().get_unique_id()] = {"name": player_name_edit.text}
	send_player_data()
	return



func load_map(scene_path: String):
	#U.fade_in_screen(self)
	for world in $Worlds.get_children():
		world.free()
	$Worlds.add_child(load(scene_path).instantiate())
	return

@rpc("call_local")
func load_host_map(host_world: World):
	U.fade_in_screen(self)
	for world in $Worlds.get_children():
		world.free()
	$Worlds.add_child(host_world)
	return

func add_listed_player(player_name: String):
	var new_player_list_item: TextEdit = player_list_item_template.duplicate()
	player_list.add_child(new_player_list_item)
	new_player_list_item.text = player_name
	new_player_list_item.visible = true
	return


func ui_switch_to_main():
	netstart_ui.hide()
	lobby_container.hide()
	
	
	netmain_ui.show()
	netmain_ui.grab_focus()
	return

func _notification(what):
	if what == NOTIFICATION_WM_CLOSE_REQUEST:
		get_tree().quit() # default behavior


func _on_spawn_pressed():
	# Current world from blackboard
	if not Blackboard.current_world:
		prints(self.name, "!! Blackboard has no current world.")
		return
	# Instance player with name as net id
	var current_world: World = Blackboard.current_world
	#var spawn_position: Vector3 = current_world.get_random_spawn()
	var spawn: Node3D = current_world.get_random_spawn()
	var my_peer_id: int = multiplayer.get_unique_id()
	current_world.rpc("add_player", my_peer_id, spawn.global_position, spawn.global_rotation)
	await get_tree().process_frame
	
	var input_proxy: Node = get_tree().get_first_node_in_group("input_proxies")
	#var assumed_receiver: Node3D = get_tree().get_first_node_in_group("peer_"+str(multiplayer.get_unique_id()))
	var assumed_receiver: Node3D = self.get_node(NodePath("Worlds/core_rnd/player_container/" + str(my_peer_id)))
	input_proxy.receiver = assumed_receiver
	add_remote_receiver.rpc(input_proxy.get_path(), assumed_receiver.get_path())
	
	netmain_ui.hide()
	return

@rpc("any_peer", "call_remote")
func add_remote_receiver(input_proxy_path: NodePath, new_receiver_path: NodePath):
	var input_proxy: Node = self.get_node(input_proxy_path)
	var new_receiver: Node3D = self.get_node(new_receiver_path)
	input_proxy.not_my_receivers.append(new_receiver)
	return

@rpc("any_peer", "call_local") # Maybe not needed? Unless another peer requests?
func send_player_data():
	var peers: Array = get_tree().get_multiplayer().get_peers()
	var my_peer_id: int = get_tree().get_multiplayer().get_unique_id()
	var my_player_data: Dictionary = {
		"id": my_peer_id,
		"name": player_name_edit.text
	}
	for peer in peers:
		rpc_id(peer, "set_player_data", my_player_data)
		rpc_id(peer, "update_player_list")
	return

@rpc("any_peer", "call_local")
func set_player_data(player_data: Dictionary):
	player_peers[player_data["id"]] = {}
	for player_prop in player_data.keys():
		player_peers[player_data["id"]][player_prop] = player_data[player_prop]
	return

##############################
## DEBUG
##############################
@rpc("any_peer", "call_local")
func net_print(message: String):
	prints(self.name, "peer", str(multiplayer.get_unique_id()), "received message:", message)
	return

@rpc("any_peer", "call_local")
func net_node_test(attach_to_path: NodePath, new_node: Node):
	get_node(attach_to_path).add_child(new_node)
	return

func _on_debug_button_pressed():
	#var message: String = "Hello from " + player_name_edit.text + str(multiplayer.get_unique_id()) +"!"
	#rpc("net_print", message)
	#var new_node: Label = Label.new()
	#new_node.text = "new label from " + player_name_edit.text
	#var attach_to_node: NodePath = NodePath($netstart_buttons.get_path())
	#rpc("net_node_test", attach_to_node, new_node)
	prints(self.name, str(Input.mouse_mode))
	return


func _on_launch_pressed():
	load_map.call_deferred(net_dark_room_fpath)
	return


func _on_abort_pressed():
	get_tree().get_multiplayer().multiplayer_peer = null
	lobby_container.hide()
	netstart_ui.show()
	return



func _on_worlds_child_entered_tree(node):
	prints(self.name, multiplayer.get_unique_id(), "Child entered tree:", node)
	if is_instance_of(node, World):
		ui_switch_to_main()
	return


func _on_debug_timer_timeout():
	### DEBUG ###
	#if Input.is_action_just_pressed("dev_button") and not Input.is_action_pressed("mod"):
		#net_player_index += 1
	#if Input.is_action_just_pressed("dev_button") and Input.is_action_pressed("mod"):
		#net_player_index -= 1
	var players: Array = get_tree().get_nodes_in_group("players")
	if not players: return
	var chosen_player: Node3D = players[net_player_index]
	$vinput_dash.text = "net_player: " + str(net_player_index)
	$vinput_dash.text += "\n" + str(randf())
	$vinput_dash.text += chosen_player.name
	$vinput_dash.text += "\n"
	$vinput_dash.text += str(chosen_player.VirtualInput.event_queue)
	return
