extends CharacterBody3D

@export var enable_gravity: bool = false
var sound_velo_ratio: float = 0.0

func _ready() -> void:
	for actor in get_tree().get_nodes_in_group("actors"):
		if not is_instance_of(actor, PhysicsBody3D):
			continue
		self.add_collision_exception_with(actor)
	
	#if not self.velocity.is_zero_approx():
		#move_and_slide()
	return

func _physics_process(delta: float) -> void:
	var velo_size: float = absf(self.velocity.length())
	if velo_size > 0.0:
		move_and_slide()
		self.velocity = self.velocity.move_toward(Vector3.ZERO, .2)
		debug_label_control()
		
		if velo_size > 1.0:
			if not $rollsound.playing:
				$rollsound.playing = true
			var velo_ratio: float = velo_size / 10.0
			if sound_velo_ratio < velo_ratio * .75:
				sound_velo_ratio += lerpf(0.0, velo_ratio, .10)
				$rollsound.pitch_scale = lerpf(1.00, .95, sound_velo_ratio)
				$rollsound.volume_db = lerpf(-16, 0, sound_velo_ratio)
			else:
				$rollsound.pitch_scale = lerpf(1.00, .95, velo_ratio)
				$rollsound.volume_db = lerpf(-16, 0, velo_ratio)
	else:
		$rollsound.playing = false
	
	if enable_gravity and not self.is_on_floor():
		velocity.y -= 9.0
		if velocity.abs().is_zero_approx():
			move_and_slide()
	return

func _on_area_3d_body_entered(body: Node3D) -> void:
	if body.is_in_group("actors") and is_instance_of(body, PhysicsBody3D):
		take_actor_collision(body)
		return
	return

func take_actor_collision(body) -> void:
	if not body.get("velocity"):
		return
	var body_velo: Vector3 = body.velocity
	var new_velo: Vector3 = body_velo * Vector3(1, 0, 1)
	self.velocity += new_velo # body.velocity
	get_tree().create_tween().tween_property(
		$model,
		"rotation_degrees:y",
		$model.rotation_degrees.y + randf_range(-90, 90),
		randf_range(0.2, 1.2)
	).set_ease(Tween.EASE_IN)
	return


func _on_phystick_timeout() -> void:
	#self.move_and_slide()
	return

func debug_label_control() -> void:
	if $debug_label.visible:
		$debug_label.text = str(self.velocity.length())
	return
