extends Area3D

@export var msg_text: String = "Hello!"
@export var msg_duration: float = 0.0
@export var die_on_trigger: bool = true


# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass


func _on_body_entered(body):
	if body and not body.is_in_group("players"):
		return
	var assumed_player: Node3D = get_tree().get_first_node_in_group("players")
	if msg_duration == 0.0:
		assumed_player.hud.set_doom_message(msg_text)
	else:
		assumed_player.hud.set_doom_message(msg_text, msg_duration)
	await get_tree().create_timer(msg_duration + 3.0).timeout
	self.queue_free()
