extends StaticBody3D

signal custom_audio_ended(audio_name)

@export var custom_audio: AudioStream
@export_enum("always", "paid") var custom_audio_playtype: String = "paid"
@onready var custom_audio_player: AudioStreamPlayer3D = $custom_audio_player
@onready var phone_receiver_onhook: MeshInstance3D = $sqe_payphone/phone_receiver
@onready var actor_phone_receiver: Node3D = $held_payphone_receiver
var active_user: Node3D
var is_paid: bool = false
var is_interaction_blocked: bool = false

func _ready() -> void:
	if custom_audio:
		custom_audio_player.stream = custom_audio
		prints(self.name, custom_audio.resource_name)
		prints(self.name, custom_audio.resource_path)
	return


func _process(delta: float) -> void:
	if active_user:
		var user_dist: float = active_user.global_position.distance_squared_to(self.global_position)
		if $debug_label.visible: $debug_label.text = str(user_dist)
		if user_dist > 55.0:
			terminate_usage(active_user)
	return

func interact(caller: Object) -> void:
	if is_interaction_blocked:
		return
	
	if caller == active_user:
		if custom_audio_player.playing and custom_audio_player.stream.resource_path.contains("healerphone_effects_combined_noko_and_sara"):
			_custom_audio_ended_emitfunc()
		terminate_usage(active_user)
		return
	
	is_interaction_blocked = true
	$usage_cooloff.start()
	
	if caller.has_method("take_phone_receiver"):
		active_user = caller
		$pick_up.play(); await get_tree().create_timer(.25).timeout
		caller.take_phone_receiver(actor_phone_receiver)
		phone_receiver_onhook.visible = false
	
	# Audio
	if custom_audio and custom_audio_playtype == "always":
		activate_custom_audio()
	elif custom_audio and custom_audio_playtype == "paid" and is_paid:
		activate_custom_audio()
	else:
		activate_initial_deposit_audio()
	return

func terminate_usage(user: Node3D) -> void:
	if is_interaction_blocked:
		return
	is_interaction_blocked = true
	$usage_cooloff.start()
	
	stop_all_audio()
	
	if not user:
		return
	
	user.release_phone_receiver()
	$hang_up.play()
	await get_tree().create_timer(.23).timeout
	phone_receiver_onhook.visible = true
	active_user = null
	return

func stop_all_audio() -> void:
	self.find_children("*", "AudioStreamPlayer3D").map(func(a): a.stop())
	return

func activate_custom_audio() -> void:
	stop_all_audio()
	custom_audio_player.play()
	await custom_audio_player.finished
	_custom_audio_ended_emitfunc()
	return

func activate_initial_deposit_audio() -> void:
	stop_all_audio()
	$initial_deposit.play()
	return

func _on_usage_cooloff_timeout() -> void:
	is_interaction_blocked = false
	return

func _custom_audio_ended_emitfunc() -> void:
	#res://Audio/voice/Sequence/healerphone_effects_combined_noko_and_sara.ogg
	var custom_audio_name: String = custom_audio.resource_path.split("/")[-1].split(".")[0]
	custom_audio_ended.emit(custom_audio_name)
	return
