extends Node3D

var actor: PhysicsBody3D
var hand: int = -1
var hud_name: String = "pistol_fifty"
var size: int = U.weapon_sizes.PISTOL
var fire_mode: int = U.fire_modes.SEMI_AUTO
var fire_rate: float = 75.0
var sound_distance: float = 80.0

@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $model/AnimationPlayer
@onready var mag_model: Node3D = $Cache/pistol_9mm_mag
@onready var aim_dot: MeshInstance3D = $aim_dot
@onready var shell_casing: Node3D = $"Cache/9_mm_shell_casing"
@onready var muzzle_smoke: Node3D = $Cache/muzzle_smoke_effect
@onready var sound_shoot: AudioStreamPlayer3D = $Sounds/s_shoot_1
@onready var sound_reload: AudioStreamPlayer3D = $Sounds/reload
@onready var sound_dryfire: AudioStreamPlayer3D = $Sounds/dryfire
var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")

var shoot_anim: String = "shoot_immediate"
var default_shoot_sound_pitch: float = 1
var default_aim_dot_color: Color = Color(1, 1, 1, 1)
@export var target_aim_dot_color: Color = Color(1, 0, 0, 0.5216)
@export var notarget_aim_dot_color: Color = default_aim_dot_color

@export var prop_weapon: bool = false
@export var suppress_aimdot: bool = false
var damage: int = 36
var knockback_force: float = 15.0
var recoil: float = 18.0
var primary_action_type: int = U.primary_action_types.TAP

var shoot_sounds: Array = []
var aim_dot_controller: Node

func _ready():
	#$model/armature/Skeleton3D/silencer.visible = false
	
	shoot_sounds = $Sounds.find_children("s_shoot_*")
	
	if not actor:
		find_item_actor()
	
	if prop_weapon:
		raycast.enabled = false
		aim_dot.visible = false
	
	if not aim_dot_controller:
		aim_dot_controller = self
	return

func _process(delta):
	if prop_weapon:
		return
	
	if aim_dot_controller == self:
		aim_dot_control()
	return

# ---------------------

func find_item_actor():
	#var parent_owner: CharacterBody3D = self.get_parent().owner
	var parent_owner: PhysicsBody3D = self.get_parent().owner
	if parent_owner:
		actor = parent_owner
		return
	
	if not parent_owner:
		await self.get_parent().ready
		parent_owner = self.get_parent().owner
		return parent_owner if parent_owner else null
	
	return

func aim_dot_control():
	if suppress_aimdot:
		aim_dot.visible = false
		return
	
	if raycast.is_colliding():
		var collision_point: Vector3 = raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = raycast.get_collider()
		if collider and raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = target_aim_dot_color #Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = notarget_aim_dot_color #default_aim_dot_color
		
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func custom_impact_control():
	return

func spawn_muzzle_smoke():
	var new_muzzle_smoke: Node3D = muzzle_smoke.duplicate()
	var assumed_world = Blackboard.current_world
	assumed_world.add_child(new_muzzle_smoke)
	new_muzzle_smoke.global_position = muzzle_smoke.global_position
	new_muzzle_smoke.global_rotation = muzzle_smoke.global_rotation
	#new_muzzle_smoke.skinny_puff()
	#new_muzzle_smoke.puff() # Skinny shows up, this one doesn't. Dunno why
	
	# Will it work without the next line?
	#new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func spawn_shell_casing():
	var new_shell_casing: Node3D = shell_casing.duplicate()
	var assumed_world = Blackboard.current_world
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = shell_casing.global_position
	new_shell_casing.global_rotation = shell_casing.global_rotation
	new_shell_casing.eject_random()
	# Will it work without the next line?
	#new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func stop_action():
	anim.stop()
	anim.play("idle")
	return

func primary_action(caller):
	trigger_down(caller)
	return

func trigger_down(caller):
	anim.stop()
	anim.play(shoot_anim)
	anim.queue("idle")
	flash_muzzle_flare()
	
	#randomize_pitch()
	#sound_shoot.play()
	U.random_choice(shoot_sounds).play()
	
	#A.create_impact(actor, raycast, damage, knockback_force)
	var hit_recipient: Node3D = A.create_impact(actor, raycast, damage, knockback_force)
	if is_instance_of(hit_recipient, CharacterBody3D):
		#A.apply_move(hit_recipient, Vector2(0, -1), knockback_force)
		hit_recipient.velocity += (hit_recipient.global_position - self.global_position) * (knockback_force * .1)
		A.gradual_velo_stop(hit_recipient, Vector3.ZERO, .7)
	
	spawn_shell_casing()
	spawn_muzzle_smoke()
	
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position, sound_distance)
		caller.recoil_kick(recoil)
	return

func trigger_up():
	return

func reload(caller):
	sound_reload.play()
	#anim.play("reload")
	drop_mag()
	return

func dry_fire(caller):
	sound_dryfire.play()
	return

func show_as_empty():
	anim.stop()
	#anim.play("empty")
	return

func drop_mag():
	mag_model.position = Vector3.ZERO
	
	var new_mag_model: Node3D = mag_model.duplicate()
	Blackboard.current_world.add_child(new_mag_model)
	new_mag_model.global_position = mag_model.global_position
	new_mag_model.visible = true
	var duration: float = 1.2
	var final_global_position: Vector3 = new_mag_model.global_position
	final_global_position += Vector3(0.3, -5.4, 0.0)
	var final_global_rotation: Vector3 = new_mag_model.global_rotation
	final_global_rotation += Vector3(25.0, 0.0, 5.0)
	get_tree().create_tween().tween_property(new_mag_model, "global_position", final_global_position, duration).set_trans(Tween.TRANS_QUAD) #.set_trans(Tween.TRANS_BACK)
	get_tree().create_tween().tween_property(new_mag_model, "global_rotation", final_global_rotation, duration).set_trans(Tween.TRANS_CUBIC)
	await get_tree().create_timer(duration).timeout
	new_mag_model.queue_free()
	return

func randomize_pitch():
	sound_shoot.pitch_scale = randf_range(1.0, 1.2)
	return

func flash_muzzle_flare():
	$muzzle_flare.visible = true
	$muzzle_flare_light.visible = true
	await get_tree().create_timer(.07).timeout
	$muzzle_flare.visible = false
	$muzzle_flare_light.visible = false
	return

func set_dark_weapon_theme():
	$model/armature/Body.set_surface_override_material(1, load("res://Resources/generic_dark_grey_material.tres"))
	$model/armature/Skeleton3D/Slid.set_surface_override_material(0, load("res://Resources/generic_lessdark_grey_material.tres"))
	return
