extends Control

# What should be here?
# - Mouse sensitivity
# - Remap controls
# - Resolution, windowed, fullscreen?
# - Volume
# - Invert horizontal axis when flipped, true or false
@onready var videomode_option: OptionButton = $VBoxContainer/hbox_videomode/videomode_option
const DEFAULT_WINDOWED_SIZE: Vector2 = Vector2(1080, 675)

func _ready():
	$VBoxContainer/hbox_mouse_sensitivity/mouse_sensitivity_edit.text = str(Global.mouse_sensitivity)
	return

func _on_back_pressed():
	self.visible = false
	return


func _on_mouse_sensitivity_edit_text_changed(new_text: String) -> void:
	Global.mouse_sensitivity = float(new_text)
	Global.apply_mouse_sensitivity()
	return



func _on_volume_edit_text_changed(new_text: String) -> void:
	#Global.master_volume_percent = clampf(float(new_text), 0.0, 100.0)
	#Global.apply_master_volume()
	return


func _on_volume_slider_value_changed(value: float) -> void:
	$VBoxContainer/hbox_volume/volume_edit.text = str(value)
	#Global.master_volume_percent = clampf(value, 0.0, 100.0)
	Global.master_volume_percent = value
	Global.apply_master_volume()
	return


func _on_visibility_changed() -> void:
	if self.visible:
		$VBoxContainer/hbox_volume/volume_edit.text = str(Global.master_volume_percent)
		$VBoxContainer/hbox_volume/volume_slider.value = Global.master_volume_percent
		$VBoxContainer/hbox_mouse_sensitivity/mouse_sensitivity_edit.text = str(Global.mouse_sensitivity)
	else:
		pass
	return


func _on_videomode_option_item_selected(index: int) -> void:
	prints(self.name, "Selected videomode:", index)
	prints(self.name, DisplayServer.window_get_size())
	match videomode_option.get_item_text(index):
		"Fullscreen":
			DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_FULLSCREEN)
		"Windowed":
			DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_WINDOWED)
			DisplayServer.window_set_size(DEFAULT_WINDOWED_SIZE)
	return
