extends Node3D

var actor: CharacterBody3D
var hand: int = -1
var hud_name: String = "shotgun_doublebarrel"
var size: int = U.weapon_sizes.LONG
var fire_mode: int = U.fire_modes.SINGLE_ACTION
var fire_rate: float = 5.00
var sound_distance: float = 45.0

#@onready var raycast: RayCast3D = $RayCast3D
@onready var main_raycast: RayCast3D = $raycast_container/RayCast3D
@onready var raycast_container: Node3D = $raycast_container
@onready var anim: AnimationPlayer = $AnimationPlayer
@onready var model_anim: AnimationPlayer = $shotgun_doublebarrel/AnimationPlayer
@onready var aim_dot: MeshInstance3D = $aim_dot
var default_shoot_sound_pitch: float = 1
var default_aim_dot_color: Color = Color(1, 1, 1, 1)
@export var target_aim_dot_color: Color = Color(1, 0, 0, 0.5216)
@export var notarget_aim_dot_color: Color = Color(1, 1, 1, 1)

@export var prop_weapon: bool = false
@export var suppress_aimdot: bool = false

@onready var shoot_sounds: Array = $shoot_sound_container.get_children()

var damage: int = 170
var knockback_force: float = 35.0
var recoil: float = 25
var primary_action_type: int = U.primary_action_types.HOLD
var is_shooting: bool = false
var shoot_caller: Node
#var shoot_time: float = 0.1
var callback_data: Dictionary
var finished_shot_callback: Callable
var shoot_tick_counter: float = -1.0
var barrels_used: int = 2
var ammo_count: int = 8
var reload_count: int = 0

var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")



func _ready():
	if prop_weapon:
		model_anim.play("idle")
		for raycast in raycast_container.get_children():
			raycast.enabled = false
		aim_dot.visible = false
	else:
		model_anim.play("open")
		await get_tree().create_timer(.2).timeout
		$close_frontbreak.play()
		model_anim.play("idle")
	return


func _process(delta):
	if not prop_weapon:
		aim_dot_control()
	
	#if is_shooting and is_pumped:
		##shoot_tick_counter += delta
		##if shoot_tick_counter > (60/fire_rate):
		#if shoot_tick_counter < 0.0:
			#shoot()
			#shoot_tick_counter = (60/fire_rate)
		#
		#shoot_tick_counter -= delta
	return

func aim_dot_control():
	if suppress_aimdot:
		aim_dot.visible = false
		return
	
	if main_raycast.is_colliding():
		var collision_point: Vector3 = main_raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = main_raycast.get_collider()
		if collider and main_raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = target_aim_dot_color #Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = notarget_aim_dot_color #default_aim_dot_color
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func shell_casing_control():
	var new_shell_casing: Node3D = $'Lazy Cache/shotgun_shell_casing'.duplicate()
	var assumed_world = get_tree().get_first_node_in_group("Worlds")
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = $'Lazy Cache/shotgun_shell_casing'.global_position
	new_shell_casing.global_rotation = $'Lazy Cache/shotgun_shell_casing'.global_rotation
	var anim_choice_index: int = randi_range(0, 2)
	var anim_name: String = ["eject", "eject_2", "eject_3"][anim_choice_index]
	new_shell_casing.get_node("AnimationPlayer").play(anim_name)
	new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	#impact_control()
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	if is_shooting:
		return
	
	#$shoot_timer.start(shoot_time)
	is_shooting = true
	anim.play("shoot auto")
	#impact_control() # Called in animation
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position, sound_distance)
		caller.recoil_kick(recoil)
	return

func stop_action():
	trigger_up()
	
	anim.stop()
	anim.play("idle")
	if primary_action_type == U.primary_action_types.HOLD:
		for shoot_sound in shoot_sounds:
			shoot_sound.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = randf_range(0.9, 1.1)
	#var first_step: int = randi_range(0, 2)
	#if first_step == 0:
		#new_pitch = randf_range(1.3, 1.5)
	#elif first_step == 1:
		#new_pitch = randf_range(1.5, 1.7)
	#elif first_step == 2:
		#new_pitch = 2.0
	for shoot_sound in shoot_sounds:
		shoot_sound.pitch_scale = new_pitch
	return

func primary_action(caller):
	#full_auto_shoot(caller)
	trigger_down(caller)
	return

func trigger_down(caller: Node):
	if is_shooting:
		return
	
	is_shooting = true
	shoot_caller = caller
	anim.play("shoot")
	if actor and actor.is_in_group("players"):
		actor.anim.stop()
	await get_tree().create_timer(.06).timeout # Keep the gun from shooting way off target mid-pump
	
	shoot()
	return

func trigger_up():
	#shoot_caller = null
	is_shooting = false # Maybe move into the SHOOTING block, maybe not. idk.
	
	#if shotgun_action_state == shotgun_action_states.SHOOTING and not is_pumped:
		#shotgun_action_state = shotgun_action_states.PUMPING
	#elif shotgun_action_state == shotgun_action_states.PUMPING and is_pumped:
		#is_pumping = false
		#shotgun_action_state = shotgun_action_states.SHOOTING
	return

func shoot():
	randomize_shoot_pitch()
	anim.play("shoot")
	#U.random_choice(shoot_sounds).play()
	#A.create_impact(actor, raycast, damage, knockback_force)
	var per_raycast_damage: int = int(damage / raycast_container.get_child_count())
	var per_raycast_knockback_force: float = knockback_force / raycast_container.get_child_count()
	#for raycast in raycast_container.get_children():
	
	var adjusted_recoil: float
	var adjusted_knockback_force: float
	var hit_recipients: Array = []
	
	#ammo_count = actor.slot_manager.get_active_item(hand)["ammo_count"]
	if prop_weapon:
		ammo_count = actor.get_active_ammo_count()
	elif not prop_weapon:
		ammo_count = actor.slot_manager.get_active_item(hand)["ammo_count"]
	
	reload_count = 0
	if ammo_count == 0:
		prints(self.name, "An ammo count of ZERO in the function shoot() was not expected.")
	elif ammo_count == 1:
		for raycast in raycast_container.find_children("*left_barrel*"):
			hit_recipients.append(
				A.create_impact(actor, raycast, per_raycast_damage, per_raycast_knockback_force)
			)
			
		shoot_sounds[0].play()
		adjusted_recoil = recoil * .5
		adjusted_knockback_force = knockback_force * .5
	elif ammo_count == 2:
		for raycast in raycast_container.find_children("*left_barrel*"):
			hit_recipients.append(
				A.create_impact(actor, raycast, per_raycast_damage, per_raycast_knockback_force)
			)
		shoot_sounds[0].play()
		for raycast in raycast_container.find_children("*right_barrel*"):
			hit_recipients.append(
				A.create_impact(actor, raycast, per_raycast_damage, per_raycast_knockback_force)
			)
		shoot_sounds[1].play()
		adjusted_recoil = recoil
		adjusted_knockback_force = knockback_force
	
	for hit_recipient in hit_recipients:
		if not is_instance_of(hit_recipient, CharacterBody3D):
			continue
		#A.apply_move(hit_recipient, Vector2.DOWN, per_raycast_knockback_force * 2)
		A.apply_move(hit_recipient, Vector2.DOWN, 55)
	
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position, sound_distance)
		if shoot_caller:
			shoot_caller.recoil_kick(adjusted_recoil)
			actor.apply_body_kickback($kickback_origin.global_position, adjusted_knockback_force)
			#A.apply_move(actor, Vector2.DOWN, adjusted_knockback_force)
	
	# Called immediately and not after the animation.
	# I don't think that's a problem.
	if finished_shot_callback:
		finished_shot_callback.call(callback_data["hand"], callback_data["iid"])
	return

func reload(caller):
	$reload.play()
	model_anim.play("open")
	if reload_count == 0:
		$shotgun_shells/AnimationPlayer.play("pop_right_extreme")
	elif reload_count == 1:
		$shotgun_shells/AnimationPlayer.play("pop_left_extreme")
	elif reload_count > 1:
		self.rotation_degrees.y += 180
	reload_count += 1
	await get_tree().create_timer(.20).timeout
	$close_frontbreak.play()
	model_anim.play("idle")
	return

func dry_fire(caller):
	stop_action()
	$dry_fire.play()
	return

func _on_delayed_ticker_timeout():
	return

func show_as_empty():
	anim.stop()
	anim.play("empty")
	return

#func pump():
	#$shotgun_buster/AnimationPlayer.play("pump")
	#actor.pump_shotgun()
	#$pump_sound.play()
	#is_pumping = true
	#is_pumped = true
	#shell_casing_control()
	#return
