@tool
extends Node3D

@onready var face_overlay: MeshInstance3D = $detective_bravura/Armature/Skeleton3D/gb_face_overlay_B
var face_material: StandardMaterial3D
@onready var faces: Array = [
	preload("res://Sprites/faces/bravura_face_overlay_speak1.png"),
	preload("res://Sprites/faces/bravura_face_overlay_speak2.png"),
	preload("res://Sprites/faces/bravura_face_overlay_speak3.png")
]
@onready var rest_face: Texture2D = preload("res://Sprites/faces/bravura_face_overlay_idle.png")
var face_index: int = 0
#"res://Staging/Models/detective_bravura.glb::StandardMaterial3D_kw3vd"

func _ready():
	if Engine.is_editor_hint(): return
	face_material = face_overlay.get_active_material(0)
	return

func _physics_process(delta):
	if Engine.is_editor_hint(): return
	
	if Input.is_action_just_pressed("dev_button") and not Input.is_action_pressed("mod"):
		set_next_face()
	if Input.is_action_just_pressed("dev_button") and Input.is_action_pressed("mod"):
		set_rest_face()
	return

func switch_to_face(index: int):
	face_material.albedo_texture = faces[index]
	return

func set_next_face():
	if Engine.is_editor_hint(): return
	face_index = U.cycled_array_index(faces, face_index)
	face_material.albedo_texture = faces[face_index]
	return faces[face_index]

func set_rest_face():
	if Engine.is_editor_hint(): return
	face_material.albedo_texture = rest_face
