extends StaticBody3D

enum target_choice_types {
	AUTO,
	ASSIGN,
	GROUPNAME
}
@export var target_choice: target_choice_types = target_choice_types.AUTO
@export var target_assigned_node: Node3D
@export var target_groupname: String = ""
@export var die_on_use: bool = true
var target: Node3D

func _ready():
	self.add_to_group("hit_takers")
	return

func set_target():
	match target_choice:
		target_choice_types.AUTO:
			if target_assigned_node:
				target = target_assigned_node
			else:
				target = find_target_by_groupname(target_groupname)
			return
			
		target_choice_types.ASSIGN:
			target = target_assigned_node
			return
			
		target_choice_types.GROUPNAME:
			target = find_target_by_groupname(target_groupname)
			return
	
	return

func find_target_by_groupname(groupname: String):
	return get_tree().get_first_node_in_group(groupname)

func hit(_damage: int, _hit_type: int, _caller: CharacterBody3D, _hit_pos: Vector3):
	set_target()
	target.activate(self)
	if die_on_use:
		await get_tree().create_timer(.1).timeout
		self.queue_free()
	return
