extends Node3D

@export var target_group: String
# Make states for mid, up, down
# Activate based on state or something I guess lol
enum switch_states {
	UP,
	MID,
	DONE
}
var switch_state: int = switch_states.MID

func activate():
	if switch_state == switch_states.MID or switch_state == switch_states.UP:
		$switch_box2/AnimationPlayer.play("switching_down")
	else:
		$switch_box2/AnimationPlayer.play("switching_up")
	$AudioStreamPlayer3D.play()
	
	if target_group:
		for group_name in target_group.split(","):
			for group_node in get_tree().get_nodes_in_group(group_name):
				if group_node.get("activate"):
					group_node.activate(self)
	return
