extends StaticBody3D

var is_broken: bool = false

func _ready():
	$tall_glass_breaking/Tall_Glass.visible = true
	for shard in $tall_glass_breaking.find_children("*shard*"):
		shard.visible = false


func hit(_damage: int, _hit_type: int, _caller: CharacterBody3D, _hit_pos: Vector3):
	#if is_dead: return # If no dead flinch, uncomment
	
	break_glass()
	return

func break_glass():
	if is_broken:
		return
	$tall_glass_breaking/Tall_Glass.visible = false
	for shard in $tall_glass_breaking.find_children("*shard*"):
		shard.visible = true
	$tall_glass_breaking/AnimationPlayer.play("Animation")
	
	for sound in self.find_children("break_sound*"):
		sound.play()
		await get_tree().create_timer(.1).timeout
	
	for actor in get_tree().get_nodes_in_group("actors"):
		self.add_collision_exception_with(actor)
	is_broken = true
	return
