extends RigidBody3D

#@export var weapon_theme: U.weapon_themes = U.weapon_themes.LIGHT
@export var drop_and_freeze: bool = true
var item_name: String = "python_357"
@export var ammo_count: int = 12
var ammo_type: int = U.ammo_types.THREE_FIFTY_SEVEN

var just_spawned: bool = true

func _ready():
	connect("body_entered", _body_entered)
	
	return

func _on_area_3d_body_entered(body):
	if body.is_in_group("players") and self.is_in_group("interactables"):
		var has_ammo: bool = ammo_count > 0
		$OmniLight3D.visible = true if has_ammo else false
		if A.distance(body, self) < 5 and ammo_count > 0 and body.has_method("ammo_from_item"):
			body.ammo_from_item(ammo_type, ammo_count)
			ammo_count = 0
	return


func _on_area_3d_body_exited(body):
	if body.is_in_group("players"):
		$OmniLight3D.visible = false
	return

func interact(caller):
	#if caller.is_in_group("players"):
		#caller.ammo_from_item(ammo_type, ammo_count)
	if caller.is_in_group("players") and ammo_count > 0:
		caller.ammo_from_item(ammo_type, ammo_count)
	caller.pickup(item_name)
	self.queue_free()
	return

func _body_entered(body):
	$clack_sound.play()
	return


func _on_spawn_cooloff_timeout():
	just_spawned = false
	return


func _on_rest_timer_timeout():
	if not drop_and_freeze: return
	freeze = true # This isn't needed, thought it would solve a performance issue
	return

