extends StaticBody3D

#@onready var platform: AnimatableBody3D = $platform
@export var platform: AnimatableBody3D

## Make the elevator go up and down. Frightening!
var travel_top: Marker3D
var travel_bottom: Marker3D
var travel_time: float = 2.8
var elevator: Node3D
var always_update_position: bool = false

enum travel_states {
	TRAVELED_TOP,
	TRAVELING_TOP,
	TRAVELING_BOTTOM,
	TRAVELED_BOTTOM
}
var travel_state: int = travel_states.TRAVELED_BOTTOM
var previous_state: int = travel_state
var is_state_locked: bool = false

func _ready():
	platform.get_node("CollisionShape3D").disabled = true
	return


func interact(_caller: Node = null) -> void:
	if is_state_locked: return
	if travel_state == travel_states.TRAVELED_BOTTOM: travel_up(); return
	if travel_state == travel_states.TRAVELED_TOP: travel_down(); return
	return

func travel_up():
	if is_state_locked:
		return
	if not travel_top:
		travel_top = get_node(self.get_parent().travel_top_npath)
	
	switch_state(travel_states.TRAVELING_TOP)
	is_state_locked = true
	if elevator.door_state == elevator.door_states.OPENED:
		elevator.close_doors()
	
	$moving.play()
	#platform.get_node("CollisionShape3D").disabled = false
	# POS
	get_tree().create_tween().tween_property(
		elevator,
		"global_position",
		travel_top.global_position,
		travel_time
	)
	# ROT
	get_tree().create_tween().tween_property(
		elevator,
		"global_rotation",
		travel_top.global_rotation,
		travel_time
	)
	
	await get_tree().create_timer(travel_time).timeout
	$moving.stop()
	$move_stop.play()
	switch_state(travel_states.TRAVELED_TOP)
	platform.get_node("CollisionShape3D").disabled = true
	is_state_locked = false
	
	if elevator.door_state == elevator.door_states.CLOSED:
		elevator.open_doors()
	return

func travel_down():
	if is_state_locked:
		return
	
	if not travel_bottom:
		travel_bottom = get_node(self.get_parent().travel_bottom_npath)
	switch_state(travel_states.TRAVELING_BOTTOM)
	is_state_locked = true
	
	if elevator.door_state == elevator.door_states.OPENED:
		elevator.close_doors()
	
	$moving.play()
	#platform.get_node("CollisionShape3D").disabled = false
	
	# POS
	get_tree().create_tween().tween_property(
		elevator,
		"global_position",
		travel_bottom.global_position,
		travel_time
	)
	# ROT
	get_tree().create_tween().tween_property(
		elevator,
		"global_rotation",
		travel_bottom.global_rotation,
		travel_time
	)
	await get_tree().create_timer(travel_time).timeout
	$moving.stop()
	$move_stop.play()
	switch_state(travel_states.TRAVELED_BOTTOM)
	platform.get_node("CollisionShape3D").disabled = true
	is_state_locked = false
	
	if elevator.door_state == elevator.door_states.CLOSED:
		elevator.open_doors()
	return

func switch_state(new_state: int):
	if always_update_position:
		elevator.update_group_positions()
		prints(self.name, travel_top, travel_bottom)
	
	previous_state = travel_state
	travel_state = new_state
	return
