@tool
extends Node3D

# On TB map rebuild this node gets the brush mesh as a child with no collider.
# Make a static body out of it, give it health.

@export var glass_phys_node: StaticBody3D
@export var alpha_texture: int = 0
@export var gd_group: String = ""
var glass_shards_scene: Resource = preload("res://Scenes/glass_particles.tscn")

func _ready():
	if gd_group:
		self.add_to_group(gd_group)
	return

func _editor_ready():
	if not Engine.is_editor_hint(): return
	
	for mesh_parent in self.get_children():
		if is_instance_of(mesh_parent, MeshInstance3D):
			mesh_parent.create_convex_collision()
			for mesh_child in mesh_parent.get_children():
				if is_instance_of(mesh_child, StaticBody3D):
					mesh_child.set_script(load("res://entities/gd_breakable_wideglass_brush.gd"))
					glass_phys_node = mesh_child
					mesh_child.glass_top_node = self
					mesh_child.mesh = mesh_parent
	return

func kill_glass():
	if Engine.is_editor_hint(): return
	
	$kill_delay.start()
	$sound_hit.play()
	glass_phys_node.mesh.visible = false
	glass_phys_node.process_mode = PROCESS_MODE_DISABLED
	
	# Throw shards
	var glass_shards: GPUParticles3D = glass_shards_scene.instantiate()
	self.add_child(glass_shards)
	glass_shards.global_position = self.global_position
	glass_shards.emitting = true
	return


func _on_kill_delay_timeout():
	self.queue_free()
	return
