extends Node3D

@export var glass_top_node: Node3D
@export var mesh: MeshInstance3D
@export var health: int = 5 :
	get:
		return health
	set(value):
		health = value
		if death_check() and glass_top_node:
			die()



func _ready():
	self.add_to_group("breakables")
	self.add_to_group("hit_takers")
	self.add_to_group("windows")
	return

func death_check():
	if health < 1:
		return true
	elif health > 0:
		return false
	return

#func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
func hit(damage: int, hit_type: int, caller: Node3D, hit_pos: Vector3):
	if death_check(): return
	
	var is_regular_hit: bool = (
		hit_type == U.hit_types.UNDEFINED or \
		hit_type == U.hit_types.RAYCAST or \
		hit_type == U.hit_types.AREA
	)
	#if hit_type == U.hit_types.UNDEFINED:
	if is_regular_hit:
		health -= damage
	if hit_type == U.hit_types.KICK:
		health -= damage
	return


func die():
	if not glass_top_node:
		glass_top_node = get_parent().get_parent()
	glass_top_node.kill_glass()
	return
