@tool
extends Node3D


@export var brush_groupname: String
var brush_swap_master: Node3D
var brush_swap_target: Node3D

@export var enable_collisions: int = 1
@export var hit_trigger: int = 1
@export var alpha_texture: int = 0

func _editor_ready():
	if not Engine.is_editor_hint():
		return
		
	if enable_collisions:
		for c in self.get_children():
			if not is_instance_of(c, MeshInstance3D):
				continue
			c.create_convex_collision(true, false)
			if hit_trigger:
				await get_tree().process_frame
				var assumed_collider: StaticBody3D = c.get_child(0)
				assumed_collider.set_script(load("res://Scripts/childnode_activator.gd"))
	return

func _ready():
	if Engine.is_editor_hint(): return
	
	var assumed_collider: StaticBody3D = self.get_child(0).get_child(0)
	assumed_collider.connect("activated", _child_activated)
	return

func activate(_caller):
	if Engine.is_editor_hint(): return
	
	if not brush_groupname:
		return
	
	if not brush_swap_master:
		brush_swap_master = self
	
	var world_map: TBLoader = get_tree().get_first_node_in_group("trenchbroom_maps")
	for map_item in world_map.get_children():
		if not map_item.name.begins_with(brush_groupname):
			continue
		if map_item.name.begins_with(brush_groupname):
			brush_swap_target = map_item
			break
	
	if not brush_swap_target:
		prints(self.name, "Brush swap target", brush_groupname, "not found in", world_map.name)
	
	# Now switch the positions of each one
	var original_master_pos: Vector3 = brush_swap_master.global_position
	var original_target_pos: Vector3 = brush_swap_target.global_position
	brush_swap_master.global_position = original_target_pos
	brush_swap_target.global_position = original_master_pos
	return

func _child_activated():
	activate(self)
	return
