@tool
extends Node3D

enum anim_types {
	NONE,
	DROP_TOGGLE
}
enum trigger_types {
	PRESS,
	HIT
}
enum collider_types {
	SCENE_BOX,
	BRUSH_MESH
}
enum button_types {
	STANDARD,
	TOGGLE
}

@export var target_group: String
@export var keyname: String
@export var anim_type: int
@export var trigger_type: int
@export var collider_type: int
var is_locked: bool = false

var trigger_body: PhysicsBody3D

func _ready():
	if Engine.is_editor_hint():
		return
	
	if keyname:
		is_locked = true
	
	if collider_type == collider_types.BRUSH_MESH:
		$StaticBody3D.free()
	
		for c in self.get_children():
			if not is_instance_of(c, MeshInstance3D):
				continue
			c.create_convex_collision(true, false)
			trigger_body = c.get_child(0)
			break
		
	elif collider_type == collider_types.SCENE_BOX:
		trigger_body = $StaticBody3D
	
	trigger_body.set_script(load("res://Scripts/activate_parent.gd"))
	trigger_body._init()
	return

func activate(caller: Object = null):
	match anim_type:
		anim_types.NONE:
			pass
		anim_types.DROP_TOGGLE:
			var original_y: float = self.global_position.y
			var drop_offset: float = 0.5
			var drop_y: float = self.global_position.y - drop_offset
			var tween_drop: Tween = get_tree().create_tween()
			var tween_lift: Tween = get_tree().create_tween()
			var tween_duration: float = .1
			tween_drop.tween_property(self, "global_position:y", drop_y, tween_duration)
			tween_lift.tween_property(self, "global_position:y", original_y, tween_duration).set_delay(tween_duration)
	
	var activation_caller: Object
	if caller:
		activation_caller = caller
	else:
		activation_caller = self
	
	var caller_doorkeys: Array
	if caller:
		caller_doorkeys = caller.get("door_keys") if caller.get("door_keys") else []
	if caller_doorkeys and keyname and keyname in caller_doorkeys:
		is_locked = false
	
	if is_locked:
		return
	
	var split_target_groups: Array = []
	if target_group.contains(","):
		split_target_groups = target_group.split(",")
	else:
		split_target_groups.append(target_group)
	for split_group in split_target_groups:
		for triggered in get_tree().get_nodes_in_group(split_group):
			if triggered.has_method("activate"):
				if triggered.get("is_locked"):
					triggered.is_locked = false
				triggered.activate(activation_caller)
	return
