extends CSGCombiner3D

var hit_count: int = 0
@export var hit_threshold: int = 7
enum hit_break_types {
	NOCOLLISION,
	REMOVE
}
@export var hit_break_type: int = hit_break_types.NOCOLLISION

func _ready():
	for child in self.get_children():
		if not is_instance_of(child, MeshInstance3D):
			continue
		$CSGMesh3D.mesh = child.mesh
		child.queue_free()
		
	return


func hit(damage: int, hit_type: int, caller: CharacterBody3D, hit_pos: Vector3):
	hit_count += 1
	if hit_count >= hit_threshold:
		break_csg()
	return

func break_csg():
	match hit_break_type:
		hit_break_types.NOCOLLISION:
			self.use_collision = false
		hit_break_types.REMOVE:
			self.queue_free()
	return
