extends Node3D

	#brush_health(number) : "Health" : 1
	#brush_killable(bool) : "Killable" : 1
	#debris_on_hit(bool) : "Debris on hit" : 1
	#debris_on_die(bool) : "Debris on die" : 1
	#brush_groupname(string) : "Brush group name" : ""
	#collisions(choices)  : "collisions": 1 : "Collisions" =
	#[
		#0 : "ALL"
		#1 : "ALL EXCEPT ACTORS"
	#]
	#alpha_texture(bool) : "Alpha texture" : 0

@export var brush_health: int
@export var brush_killable: bool
@export var debris_on_hit: bool
@export var debris_on_die: bool
@export var debris_scale: float
@export var debris_portion: float
@export var brush_groupname: String
enum collision_opts {
	ALL = 0,
	ALL_EXCEPT_ACTORS = 1
}
@export var collisions: collision_opts
var is_dead: bool = false
var time_to_die: float = 1.5
var brush_material: Material
var debris_effect_pkt: PackedScene = preload("res://Scenes/debris_effect.tscn")
var debris_effect: Node3D

func _ready() -> void:
	self.add_to_group("hit_takers")
	self.add_to_group("debris_breakables")
	if brush_groupname:
		self.add_to_group(brush_groupname)
	brush_material = self.find_children("*", "MeshInstance3D")[0].get_active_material(0)
	debris_effect = debris_effect_pkt.instantiate()
	self.add_child(debris_effect)
	
	await get_tree().create_timer(0.1).timeout
	_post_init()
	return

func _post_init() -> void:
	debris_effect.set_materials(brush_material)
	debris_effect.visible = false
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	if is_dead:
		return
	
	if debris_on_hit:
		send_debris(hit_pos)
	
	brush_health -= damage
	
	var sound_stream_path: String = ["res://Audio/hitlike_misc_02.ogg", "res://Audio/hitlike_misc_03.ogg"].pick_random()
	var world_sound: AudioStreamPlayer3D = U.spawn_sound_player(Blackboard.current_world, self.global_position, sound_stream_path)
	world_sound.pitch_scale = randf_range(.95, 1.1)
	world_sound.play()
	
	if brush_health < 1 and brush_killable:
		kill_brush()
	return

func kill_brush() -> void:
	if is_dead:
		return
	
	
	self.visible = false
	for c in self.find_children("*", "CollisionShape3D"):
		c.disabled = true
	if debris_on_die:
		send_debris()
	is_dead = true
	
	self.remove_from_group(brush_groupname)
	if brush_groupname:
		for brush in get_tree().get_nodes_in_group(brush_groupname):
			if brush == self:
				continue
			if brush.is_dead:
				continue
			brush.kill_brush()
	
	await get_tree().create_timer(time_to_die).timeout
	self.queue_free()
	return

func send_debris(debris_position: Vector3 = Vector3.ZERO) -> void:
	#var new_effect: Node3D = debris_effect_pkt.instantiate()
	var new_effect: Node3D = debris_effect.duplicate()
	
	if debris_position:
		new_effect.global_position = debris_position
	else:
		new_effect.global_position = self.global_position
	new_effect.debris_scale = self.debris_scale
	new_effect.debris_portion = self.debris_portion
	Blackboard.current_world.add_child(new_effect)
	new_effect.set_materials(brush_material)
	new_effect.visible = true
	#new_effect.explode_and_fade()
	new_effect.explode_and_void()
	return
