@tool
extends Node3D

@export var key: String = ""
@export var is_locked: bool = false
@export var tb_flat_axis: String = "x"
@export var hinge_side: String = "a" :
	get:
		return hinge_side
	set(value):
		hinge_side = value
		match value:
			"a":
				self.scale.z = 1
			"b":
				self.scale.z = -1

@export var open_side: String = "a"
@export var speed_scale: float = 1.0
@onready var physics_body: StaticBody3D = $swing_anchor/starthouse_front_door/door_body
var is_moving: bool = false
@export var is_closed: bool = true :
	get:
		return is_closed
	set(value):
		is_closed = value
		if not Engine.is_editor_hint(): return
		
		if value:
			$AnimationPlayer.play("idle")
		elif not value:
			match open_side:
				"a":
					$AnimationPlayer.play("open_side_a")
				"b":
					$AnimationPlayer.play("open_side_b")


@export var is_interactable: bool = true


# To keep it simple you're going to have a few standard door sizes
# Tried material swapping but the textures do not align.
# Swapping the mesh as a resource does work fine.
# So just make it an option for which kind of door,
# then instance the correct mesh in editor or at runtime if you're desperate
# - One hinge side will be z scale 1, the other will be z scale -1
# - One tb_flat_axis will be x, the other will be y. If you need a trap door at z... I don't know?

func _ready():
	$AnimationPlayer.speed_scale = speed_scale
	if is_interactable:
		physics_body.add_to_group("interactables")
		physics_body.connect("activated", _child_node_activated)
	if not is_closed:
		$AnimationPlayer.play("open_side_a")
	return

func _editor_ready():
	if not Engine.is_editor_hint(): return
	
	for child in self.get_children():
		if child.name.begins_with("entity_"):
			child.free()
	return

func _child_node_activated():
	toggle_door()
	return
	
func toggle_door():
	if not $door_cooloff.is_stopped(): return
	
	if is_closed:
		$open_sound.play()
		match open_side:
			"a":
				$AnimationPlayer.play("swing_open_side_a")
			"b":
				$AnimationPlayer.play("swing_open_side_b")
	elif not is_closed:
		$close_sound.play()
		match open_side:
			"a":
				$AnimationPlayer.play("swing_closed_side_a")
			"b":
				$AnimationPlayer.play("swing_closed_side_b")
	$door_cooloff.start()
	is_closed = !is_closed
	return


func _on_door_cooloff_timeout():
	is_moving = false
	return
