extends Area3D

@export var hurt_damage: float = 1.0
@export var hurt_interval: float = 1.0
@export var spawn_invisible: bool = true
@onready var ticker: Timer = $ticker
var exceptions: Array = []

func _ready() -> void:
	ticker.wait_time = hurt_interval
	ticker.start()
	if spawn_invisible:
		self.visible = false
	await get_tree().create_timer(2.0).timeout
	monitoring = false
	return

func _on_body_entered(body: Node3D) -> void:
	if exceptions.has(body):
		return
	
	if not body.is_in_group("actors"):
		exceptions.append(body)
		return
	
	return

func hurt_bodies() -> void:
	for b in get_overlapping_bodies():
		if not b:
			continue
		if not b.is_in_group("actors"):
			continue
		#func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
		b.hit(hurt_damage, U.hit_types.AREA, null, b.global_position)
	return

func _on_ticker_timeout() -> void:
	monitoring = true
	await get_tree().create_timer(.1).timeout
	hurt_bodies()
	await get_tree().create_timer(.1).timeout
	monitoring = false
	return
