extends Node3D

signal switched(light_vis)
@export var light_target: String
var rolename: String = "lightswitch"

func _ready():
	#if light_target:
		#var light_target_groupname: String = "light_target_" + light_target
		#self.add_to_group(light_target_groupname)
	self.add_to_group(light_target)
	return

func _on_static_body_3d_activated():
	#var remote_light: OmniLight3D = get_tree().get_first_node_in_group(light_target)
	#if not remote_light:
		#prints("Lightswitch could not activate. Remote light not found in group:", light_target)
		#return
	#
	#remote_light.visible = !remote_light.visible
	
	var remote_lights: Array = get_tree().get_nodes_in_group(light_target)
	if len(remote_lights) == 0:
		prints("Lightswitch could not activate. Remote lights not found in group:", light_target)
		return
	
	var is_lights_on: bool = false
	for remote_light in remote_lights:
		if remote_light.rolename == "lightswitch":
			continue
		remote_light.visible = !remote_light.visible
		is_lights_on = remote_light.visible
	
	### Damn thing disappears! Works fine in the editor, just not at runtime
	for child in self.get_children():
		#if child.name.begins_with("entity_"):
		if is_instance_of(child, MeshInstance3D):
			child.scale.y *= -1
	
	switched.emit(is_lights_on)
	return
