extends Node3D

#@export var start_position: Vector3 # From Godot/TrenchBroom
#@export var end_position: Vector3 # From Godot/TrenchBroom
@export var target_group: String # From TrenchBroom
#@export var move_duration: float # From TrenchBroom
#@export var enable_interactions: int # From TrenchBroom | I don't think this is where to fetch it
@export var alpha_texture: int
@export var loop: bool
@export var move_with_group: bool
@export var autostart: bool
@export var doorkey: String = ""
@export var sound: int
var sound_stream_path: String


func _ready():
	await get_parent().ready
	self.name = target_group + "_gd_mover"
	var static_body: StaticBody3D
	for node_child in self.get_children():
		if not is_instance_of(node_child, MeshInstance3D):
			continue
		node_child.create_trimesh_collision()
		static_body = node_child.get_child(0)
		break
	
	match sound:
		0:
			sound_stream_path = "res://Audio/Paper Sound - 2.mp3"
		1:
			sound_stream_path = "res://Audio/stone_scrape_1.ogg"
	
	if static_body:
		static_body.set_script(
			load("res://entities/gd_mover_brush.gd")
		)
		#static_body.set("move_duration", move_duration)
		#static_body.set("enable_interactions", enable_interactions) # I don't think this is where to add it
		static_body.set("target_group", target_group)
		static_body.set("doorkey", doorkey)
		static_body.set("sound_stream_path", sound_stream_path)
		static_body.set("move_with_group", move_with_group)
		static_body.add_to_group(target_group)
		static_body.loop = self.loop
		static_body.autostart = self.autostart
		static_body.startup()


	return
