extends StaticBody3D

var parent_node: Node3D
var start_position: Vector3 # From Godot
var end_position: Vector3 # From Godot
var target_group: String # From TrenchBroom
var move_duration: float # From TrenchBroom
var enable_interactions: int # From TrenchBroom
var is_moved: bool = false
var sound_open: AudioStreamPlayer3D
var sound_close: AudioStreamPlayer3D
var loop: bool
var move_with_group: bool
var autostart: bool
var doorkey: String = ""
var trans_type: int = 0
var sound_stream_path: String = "res://Audio/Paper Sound - 2.mp3"

func startup():
	update_positions()
	#self.add_to_group("interactables")
	if enable_interactions:
		self.add_to_group("interactables")
	if autostart:
		activate()
	return

func update_positions():
	if start_position and end_position:
		return
	
	var group_nodes: Array = get_tree().get_nodes_in_group(target_group)
	var abs_start_position: Vector3
	var abs_end_position: Vector3

	if len(group_nodes) > 2:
		push_warning("More than 2 group nodes for moving " + str(self.name) + ". Too many positions/nodes, must have only 2.")
	for group_node in group_nodes:
		if "path_type" not in group_node:
			continue
		if group_node.path_type == U.marker_path_types.START_POINT:
			abs_start_position = group_node.global_position
			move_duration = group_node.move_duration
			enable_interactions = group_node.enable_interactions
			trans_type = group_node.transition_type
			continue
		elif group_node.path_type == U.marker_path_types.END_POINT:
			abs_end_position = group_node.global_position
			continue
	
	var position_diff: Vector3 = abs_end_position - abs_start_position
	start_position = self.global_position
	end_position = (self.global_position + position_diff)
	return

func activate(_caller: Object = null):
	if move_with_group:
		var group_brushes: Array = get_tree().get_nodes_in_group(target_group)
		var group_brush_states: Dictionary = {}
		for group_brush in group_brushes:
			if not "move_with_group" in group_brush:
				continue
			group_brush_states[group_brush] = group_brush.move_with_group
			group_brush.move_with_group = false
		get_tree().call_group(target_group, "activate")
		for group_brush in group_brushes:
			if not "move_with_group" in group_brush:
				continue
			group_brush_states[group_brush] = group_brush.move_with_group
			group_brush.move_with_group = true #group_brush_states[group_brush]
		return
	
	if not target_group:
		prints(self.name, " : No group identity, cannot interact.")
		push_error("Mover group identity missing.")
		return

	
	if not start_position or not end_position:
		prints(self.name, " : Could not resolve both path positions.")
		push_error("Mover positions incomplete.")
		return
	
	if not parent_node:
		parent_node = self.get_parent()
	
	var tween: Tween = get_tree().create_tween()
	tween.set_trans(trans_type)
	if move_duration == 0.0:
		move_duration = 1.0
	
	if not sound_open:
		sound_open = U.spawn_sound_player(self, self.global_position, sound_stream_path)
		#sound_open.unit_size = 35.0
		sound_open.pitch_scale = .6
		#sound_open.volume_db = -10
	if not sound_close:
		sound_close = U.spawn_sound_player(self, self.global_position, sound_stream_path)
		#sound_close.unit_size = 35.0
		sound_close.pitch_scale = .6
		#sound_close.volume_db = -10
	
	if is_moved:
		tween.tween_property(parent_node, "global_position", start_position, move_duration).from(end_position).finished
		sound_close.play()
	elif not is_moved:
		tween.tween_property(parent_node, "global_position", end_position, move_duration).from(start_position)
		sound_open.play()
	is_moved = !is_moved
	
	if self.loop:
		await get_tree().create_timer(move_duration).timeout
		activate()
	return

func interact(caller):
	if not enable_interactions:
		return
	if doorkey:
		if not caller.get("door_keys"):
			return
		
		if doorkey in caller.door_keys:
			activate(caller)
	elif not doorkey:
		activate(caller)
	return
