@tool
extends Node3D

@export var angles: Vector3

enum target_choice_types {
	AUTO,
	ASSIGN,
	GROUPNAME
}
@export var target_choice: target_choice_types = target_choice_types.AUTO
@export var target_assigned_node: Node3D
@export var target_groupname: String = ""
var target: Node3D

func _ready():
	await get_tree().create_timer(.5).timeout
	self.rotation_degrees.y = angles.y
	
	for c in self.get_children():
		#print(c)
		if is_instance_of(c, MeshInstance3D):
			c.queue_free()
			continue
		if is_instance_of(c, StaticBody3D) and c.get_script():
			c.target_groupname = target_groupname
	return
