extends Area3D

@export var target_group: String
@export var trigger_type: int
var is_already_triggered: bool = false
var trigger_types: Dictionary = {
	0: PROCESS_MODE_DISABLED,
	1: PROCESS_MODE_INHERIT
}

var die_on_trigger: bool = true

func _ready():
	self.add_to_group(target_group)
	return


func activate(_caller: Object = null):
	#if target_group == "-colliders":
	prints(self.name, "ACTIVATED")
	var colliders: Array = self.get_overlapping_bodies()
	for collider in colliders:
		if collider.name.contains("_geometry_"):
			continue
		prints(self.name, "PROCESS MODE setting on", collider.name)
		collider.process_mode = trigger_types[trigger_type]
		if collider.get("fake_process_disable"):
			collider.fake_process_disable = false
	
	if die_on_trigger:
		await get_tree().create_timer(1.0).timeout
		queue_free()
	return
