extends StaticBody3D

signal interacted(rocker_node)

var is_rocking: bool = false
var spawn_lposition: Vector3
var spawn_lrotation: Vector3

func _ready() -> void:
	spawn_lposition = self.position
	spawn_lrotation = self.rotation_degrees
	return

func _physics_process(delta: float) -> void:
	return

func interact(caller: Object = null) -> void:
	if is_rocking:
		return
	is_rocking = true
	$Audio/rocking_1.play()
	self.position.y += .05
	get_tree().create_tween().tween_property(
		self,
		"position",
		spawn_lposition,
		.79
	).set_trans(Tween.TRANS_BOUNCE).set_ease(Tween.EASE_OUT)
	
	self.rotation_degrees.x += randf_range(-11.0, 11.0)
	self.rotation_degrees.y += randf_range(-5.0, 5.0)
	self.rotation_degrees.z += randf_range(-15.0, 15.0)
	get_tree().create_tween().tween_property(
		self,
		"rotation_degrees",
		spawn_lrotation,
		.79
	).set_trans(Tween.TRANS_BOUNCE).set_ease(Tween.EASE_OUT)
	
	await get_tree().create_timer(.8).timeout
	interacted.emit(self)
	is_rocking = false
	$Audio/rocking_1.stop()
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	interact()
	return
