extends Area3D

@export var debug: bool = true

enum trigger_types {
	ONCE,
	ALWAYS
}

@export var target_group: String
@export var trigger_type: int
var is_already_triggered: bool = false

func _ready():
	connect("body_entered", _body_entered)
	return


func _body_entered(body: Node3D):
	if not is_instance_of(body, CharacterBody3D):
		return
	
	if trigger_type == trigger_types.ONCE and is_already_triggered:
		return
	
	if debug:
		prints(self.name, "TRIGGERED by", body)
	activate()
	is_already_triggered = true
	return


func activate(_caller: Object = null):
	if debug:
		prints(self.name)
	
	if target_group.contains("-colliders"):
		var colliders: Array = self.get_overlapping_bodies()
		for collider in colliders:
			if collider.has_method("activate"):
				collider.activate()
		return
	
	for triggered in get_tree().get_nodes_in_group(target_group):
		if triggered.has_method("activate"):
			triggered.activate()
	return
