extends Node3D

@export var spawn_closed: bool = true
@onready var door_closed_col: CollisionShape3D = $closed_doors/closed_collider
@onready var door_opened_collider: CollisionShape3D = $door_collider/opened_collider
@onready var elevator_door_panel: StaticBody3D = $elevator_door_panel
@onready var elevator_door_panel_col: CollisionShape3D = $elevator_door_panel/CollisionShape3D
@export_enum("TOP", "BOTTOM") var spawn_travel_position: String = "BOTTOM"
@export var spawn_travel_position_tb: int = -1
@export var travel_time: float = 2.8
@export var elevator_group: String = ""

@export_node_path("Marker3D") var travel_top_npath:
	set(value):
		travel_top_npath = value
		if elevator_door_panel:
			elevator_door_panel.travel_top = self.get_node(value)
		return
	get:
		return travel_top_npath

@export_node_path("Marker3D") var travel_bottom_npath:
	set(value):
		travel_bottom_npath = value
		if elevator_door_panel:
			elevator_door_panel.travel_bottom = self.get_node(value)
		return
	get:
		return travel_bottom_npath


enum door_states {
	OPENED,
	OPENING,
	CLOSED,
	CLOSING
}
var door_state: int = door_states.CLOSED
var previous_door_state: int = door_state
var is_state_locked: bool = false
var full_init: bool = false

func _ready():
	if spawn_closed:
		close_doors()
	else:
		open_doors()
	
	elevator_door_panel.travel_top = self.get_node(travel_top_npath)
	elevator_door_panel.travel_bottom = self.get_node(travel_bottom_npath)
	elevator_door_panel.travel_time = self.travel_time
	elevator_door_panel.elevator = self
	
	if spawn_travel_position_tb == 1:
		spawn_travel_position = "TOP"
	elif spawn_travel_position_tb == 2:
		spawn_travel_position = "BOTTOM"
	elif spawn_travel_position_tb == 0:
		pass # 0 is no choice
	
	if spawn_travel_position == "TOP":
		elevator_door_panel.travel_state = elevator_door_panel.travel_states.TRAVELED_TOP
	elif spawn_travel_position == "BOTTOM":
		elevator_door_panel.travel_state = elevator_door_panel.travel_states.TRAVELED_BOTTOM
	if elevator_group:
		self.add_to_group(elevator_group)
		elevator_door_panel.always_update_position = true
	await get_tree().create_timer(1.5).timeout
	full_init = true
	return

func activate(_caller: Node = null):
	if is_state_locked: return
	match door_state:
		door_states.OPENED:
			# Close it
			close_doors()
			return
		door_states.OPENING:
			return
		door_states.CLOSED:
			# Open it
			open_doors()
		door_states.CLOSING:
			return
	return

func close_doors():
	is_state_locked = true
	switch_door_state(door_states.CLOSING)
	if full_init:
		$AudioStreamPlayer3D.pitch_scale = 0.8
		$AudioStreamPlayer3D.play()
	$door_anim.play("closing")
	$door_anim.queue("closed")
	await get_tree().create_timer(.3).timeout
	
	door_closed_col.disabled = false
	#door_opened_collider.disabled = true
	is_state_locked = false
	switch_door_state(door_states.CLOSED)
	return

func open_doors():
	is_state_locked = true
	switch_door_state(door_states.OPENING)
	
	if full_init:
		$AudioStreamPlayer3D.pitch_scale = 2.0
		$AudioStreamPlayer3D.play()
	$door_anim.play("opening")
	$door_anim.queue("opened")
	await get_tree().create_timer(.3).timeout
	
	door_closed_col.disabled = true
	#door_opened_collider.disabled = false
	is_state_locked = false
	switch_door_state(door_states.OPENED)
	return

func switch_door_state(new_state: int):
	previous_door_state = door_state
	door_state = new_state
	return

func update_group_positions():
	if not elevator_group:
		return
	
	var position_container: Node3D
	for n in get_tree().get_nodes_in_group(elevator_group):
		if n == self:
			continue
		if is_instance_of(n, Marker3D):
			continue
		if n.get_child_count() < 1:
			continue
		
		position_container = n
		break
	
	if not position_container:
		return
	elevator_door_panel.travel_top = position_container.get_node("travel_top")
	elevator_door_panel.travel_bottom = position_container.get_node("travel_bottom")
	return
