extends OmniLight3D

@export var blinking: bool = false
@export var flickering: bool = false
@export var flamelike: bool = false
const FLICKERTIME_MIN: float = 0.1
const FLICKERTIME_MAX: float = 1.2
@export var flamelike_max: float = 1.08
@export var flamelike_min: float = .2 #.70
var flamelike_dir: int = 1

func _ready():
	if blinking:
		$AnimationPlayer.play("blinking")
	if flickering:
		$flicker_ticker.start()
	return

func _physics_process(delta: float) -> void:
	if flamelike:
		var light_energy_slight_offset: float = (light_energy * .15)
		light_energy = [
			randf_range(.90, 1.08),
			light_energy + light_energy_slight_offset,
			light_energy - light_energy_slight_offset
		].pick_random()
	return

func _on_flicker_ticker_timeout() -> void:
	self.visible = !self.visible
	$flicker_ticker.wait_time = randf_range(FLICKERTIME_MIN, FLICKERTIME_MAX)
	return
