extends RigidBody3D

@export var godot_y_angle: float = 0
var movement_threshold: Vector3 = Vector3.ONE
var damage: float = 40
var is_hitting: bool = false
var consecutive_hits: int = 0
var max_hits: int = 3

var is_hurting: bool = false
var temp_caller: CharacterBody3D

func _ready():
	self.global_rotation_degrees.y = -godot_y_angle
	return

func _process(delta):
	if is_hurting:
		hurt()
#	hit_control()
	return

func hurt():
	var bodies: Array = $hurt_area.get_overlapping_bodies()
	for body in bodies:
		if body == temp_caller:
			continue
		if body.is_in_group("hit_takers"):
			body.hit(damage, U.hit_types.KNOCKABLE)
	return

func hit_control():
	if self.angular_velocity > movement_threshold:
		if consecutive_hits >= max_hits:
			return
		var bodies: Array = $hurt_area.get_overlapping_bodies()
		for body in bodies:
			if body.is_in_group("hit_takers"):
				body.hit(damage, U.hit_types.UNDEFINED)
				consecutive_hits += 1
	else:
		consecutive_hits = 0
	return

func knock(caller):
	is_hurting = true
	temp_caller = caller
	$knock_timer.start()
	return


func _on_knock_timer_timeout():
	is_hurting = false
	temp_caller = null
	return
