extends StaticBody3D

signal activated

# It needs to
# - Check if the caller has the right keycard
# 	-- If not
#		reject with audio and on screen
# 	-- If so
#		erase the keycard from the caller's doorkeys
#		Play happy audio
#		Show something nice on the screen
#		Show the keycard sticking out of the interface
#		Make the interface unusable

@export var keycard: String = ""
@export var target_group: String = ""
@onready var screen_text: Label3D = $screen_text
@onready var button_viz: MeshInstance3D = $terminal_keycard/button
var is_used: bool = false
var is_fidgeting: bool = false
var screen_light_fullbright: float = 0.189
const SCREENTEXT_MAXLEN: int = 6
enum marquee_modes {
	STATIC,
	CIRCULAR,
	BOUNCE,
	FLASH
}
@export var marquee_mode: marquee_modes = marquee_modes.CIRCULAR
var previous_marquee_mode: marquee_modes = marquee_mode
@export var marquee_text: String = ""
var spawn_marquee_text: String = ""
var marquee_text_padding: String = "     "
var marquee_index: int = 0

func _ready() -> void:
	$keycard_model_anchor/cinf_keycard/keycard_black.visible = false
	$keycard_model_anchor/cinf_keycard/keycard_blue.visible = false
	$keycard_model_anchor/cinf_keycard/keycard_red.visible = false
	
	if keycard and not keycard.contains("_"):
		keycard = "keycard_" + keycard
	
	if keycard and not marquee_text:
		marquee_text = keycard.split("_")[1].to_upper() + " KEYCARD REQUIRED"
	spawn_marquee_text = marquee_text
	return

func interact(caller) -> void:
	if not "door_keys" in caller:
		prints(self.name, "Caller '", caller, "' has no door_keys property.")
		return
	
	if is_used:
		#fidget()
		return
	
	if caller.door_keys.has(keycard):
		insert_keycard(keycard)
		activate(caller)
	else:
		fidget()
	return

func insert_keycard(keycard_name: String) -> void:
	if is_used:
		return
	is_used = true
	# Play an insertion sound
	$Sounds/insert_card.play()
	# Maybe play an access granted sound
	$Sounds/access_granted.play()
	# display something on the screen
	marquee_text = "ACCESS GRANTED"
	marquee_mode = marquee_modes.CIRCULAR
	marquee_index = 0
	
	# Show the mesh
	$keycard_model_anchor/cinf_keycard.find_child(keycard_name).visible = true
	return

func fidget() -> void:
	if is_fidgeting:
		return
	is_fidgeting = true
	#-0.074
	var button_y_offset: float = -0.074
	var pushdown_time: float = .1
	var pushup_time: float = .4
	$Sounds/fidget.play()
	previous_marquee_mode = marquee_mode
	marquee_mode = marquee_modes.FLASH
	get_tree().create_tween().tween_property(button_viz,
		"position:y",
		button_y_offset,
		pushdown_time).set_ease(Tween.EASE_IN)
	await get_tree().create_timer(pushdown_time * 1.1).timeout
	get_tree().create_tween().tween_property(button_viz,
		"position:y",
		0.0,
		pushup_time).set_ease(Tween.EASE_IN)
	await get_tree().create_timer(pushup_time).timeout
	
	marquee_mode = previous_marquee_mode
	is_fidgeting = false
	# Press the little button and tell the player
	# what keycard is needed
	return


func _on_marquee_tick_timeout() -> void:
	marquee_control()
	return

func marquee_control() -> void:
	match marquee_mode:
		marquee_modes.STATIC:
			screen_text.text = "".join(marquee_text.split("").slice(0, 5))
			return
		marquee_modes.BOUNCE:
			return
		marquee_modes.FLASH:
			screen_text.text = "".join(marquee_text.split("").slice(0,5))
			screen_text.visible = !screen_text.visible
			return
		marquee_modes.CIRCULAR:
			var full_scroll_text: String = marquee_text_padding + marquee_text + marquee_text_padding
			var text_segment: String = "".join((full_scroll_text).split("").slice(marquee_index, marquee_index + 5))
			if marquee_index > full_scroll_text.length() - 1:
				marquee_index = 0
			else:
				marquee_index += 1
			screen_text.text = text_segment
			return
	return

func activate(caller) -> void:
	activated.emit()
	var activation_caller: Object
	if caller:
		activation_caller = caller
	else:
		activation_caller = self
	
	var split_target_groups: Array = []
	if target_group.contains(","):
		split_target_groups = target_group.split(",")
	else:
		split_target_groups.append(target_group)
	for split_group in split_target_groups:
		for triggered in get_tree().get_nodes_in_group(split_group):
			if triggered.has_method("activate"):
				triggered.activate(activation_caller)
	return
